;Copyright 1997 by Henter-Joyce, Inc.
;
; Updated by S. Dawes 98/05/04.
Include "hjglobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
include "default.jsm" ; message file


Script AutoStart()
; The next 2 lines ensure that the terminal screen is always maximized.
; This is necessary for the screen orientated frames to work properly. 
{Alt+Space}
{x}	
EndScript 

Script  ScriptFileName()
ScriptAndAppNames("Extra 32BIT 3270 Emulator Scripts.  Last updated 1999/09/15.")
EndScript

Script SayNextWord()
If IsPCCursor () Then 
	RouteInvisibleToPc ()
	InvisibleCursor ()
	NextWord ()
	Pause()
	RoutePcToInvisible ()
	PcCursor ()
	SayWord()
Else
	PerformScript SayNextWord()	
Endif
EndScript

Script SayPriorWord() 
If IsPCCursor () Then 
	InvisibleCursor ()
	RouteInvisibleToPc ()
	InvisibleCursor ()
	PriorWord()
	Pause()
	RoutePcToInvisible ()
	PcCursor ()
;	Delay (1)
	SayWord()
Else
	PerformScript SayPriorWord()
Endif
EndScript

Script Tab ()
StopSpeech ()
{Tab}
Pause()
	If IsPCCursor() Then
		SayLine()
	Endif
EndScript

Script BackTab () 
StopSpeech ()
	{Shift + Tab}
Pause()
	If IsPCCursor() Then
		SayLine()
	Endif
EndScript

Script Home ()
{Home}
Pause()
	If IsPCCursor() Then
		SayLine()
Else
	PerformScript JawsHome()
	Endif
EndScript

; Local Functions:

Function RoutePcToInvisible ()
Var 
	Int InvisibleRow, ; The Row Coordinate of the InvisibleCursor
Int InvisibleCol  ; The Col Coordinate of the InvisibleCursor
InvisibleCursor ()
Let InvisibleRow = GetCursorRow ()
Let InvisibleCol = GetCursorCol ()
PcCursor ()
MoveTo (InvisibleCol, InvisibleRow)
If ((GetCursorRow ()!= InvisibleRow) &&  (GetCursorCol () != InvisibleCol)) Then
	return False
Else
	return True
EndIf
EndFunction

